'*************************************************************
' Module NAME: gsINIFileS Module
'   Company: VB Tips & Tricks
'   by David McCarter on 04/01/1996
'   written in Visual Basic 3.0
'*************************************************************
Option Explicit

Declare Function WritePrivateProfileString Lib "Kernel" (ByVal AppName As String, ByVal KeyName As String, ByVal NewString As String, ByVal filename As String) As Integer
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal AppName As String, ByVal KeyName As String, ByVal default As String, ByVal ReturnedString As String, ByVal MAXSIZE As Integer, ByVal filename As String) As Integer
Declare Function GetProfileInt Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal nDefault%) As Integer
Declare Function GetProfileString Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%) As Integer
Declare Function WriteProfileString Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpString$) As Integer
Declare Function GetPrivateProfileInt Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal nDefault%, ByVal lpFileName$) As Integer

'*************************************************************
' FUNCTION NAME: iReadINI
'   Company: VB Tips & Tricks
'   by David McCarter on 03/27/1996
'   written in Visual Basic 3.0
'
' PURPOSE:
'   Reads an integer value from an INI file
'
' INPUT PARAMETERS:
'   AppName: INI Section Heading Name
'   KeyName: Parameter Name
'   Filename: INI File Name
'   iDefault: Default value
'
' EXAMPLE(S):
'   iReadINI("USER","TIMES","C:\APP\APP.INI",0)
'*************************************************************
Function iReadINI (AppName, KeyName, filename As String, iDefault As Integer) As Integer

    iReadINI = GetPrivateProfileInt(AppName, ByVal KeyName, iDefault, filename)

End Function

'*************************************************************
' FUNCTION NAME: sReadINI
'   Company: VB Tips & Tricks
'   by David McCarter on 03/27/1996
'   written in Visual Basic 3.0
'
' PURPOSE:
'   Reads a string from an INI file
'
' INPUT PARAMETERS:
'   AppName: INI Section Heading Name
'   KeyName: Parameter Name
'   Filename: INI File Name
'
' EXAMPLE(S):
'
'*************************************************************
Function sReadINI (AppName, KeyName, filename As String) As String
Dim sRet As String

    sRet = String(255, Chr(0))

    sReadINI = Left(sRet, GetPrivateProfileString(AppName, ByVal KeyName, "", sRet, Len(sRet), filename))

End Function

'*************************************************************
' SUB NAME: WriteINI
'   Company: VB Tips & Tricks
'   by David McCarter on 03/27/1996
'   written in Visual Basic 3.0
'
' PURPOSE:
'   Writes a string to a INI file
'
' INPUT PARAMETERS:
'   sAppname: INI Section Heading Name
'   sKeyName: Parameter Name
'   sNewString: Parameter Value
'   sFileName: INI File Name
'
' SPECIAL INSTRUCTIONS:
'   If you do not use a complete file path, the INI file
'   will be created in the c:\windows directory
'
' EXAMPLE(S):
'
'*************************************************************
Sub WriteINI (sAppname, sKeyName, sNewString, sFileName As String)
Dim R As Integer
    
    R = WritePrivateProfileString(sAppname, sKeyName, sNewString, sFileName)

End Sub

